/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCamelContextDumpRoutesAsYamlTest
extends ManagementTestSupport {
    @Test
    public void testDumpAsYaml() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        String yaml = (String)mbeanServer.invoke(on, "dumpRoutesAsYaml", null, null);
        Assertions.assertNotNull((Object)yaml);
        this.log.info(yaml);
        Assertions.assertTrue((boolean)yaml.contains("route"));
        Assertions.assertTrue((boolean)yaml.contains("myRoute"));
        Assertions.assertTrue((boolean)yaml.contains("myOtherRoute"));
        Assertions.assertTrue((boolean)yaml.contains("direct:start"));
        Assertions.assertTrue((boolean)yaml.contains("{{result}}"));
        Assertions.assertTrue((boolean)yaml.contains("seda:bar?size=1234&multipleConsumers=true"));
        Assertions.assertTrue((boolean)yaml.contains("ref:bar"));
        Assertions.assertTrue((boolean)yaml.contains("expression: bar"));
    }

    @Test
    public void testDumpAsYamlResolvePlaceholder() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        String yaml = (String)mbeanServer.invoke(on, "dumpRoutesAsYaml", new Object[]{true}, new String[]{"boolean"});
        Assertions.assertNotNull((Object)yaml);
        this.log.info(yaml);
        Assertions.assertTrue((boolean)yaml.contains("route"));
        Assertions.assertTrue((boolean)yaml.contains("myRoute"));
        Assertions.assertTrue((boolean)yaml.contains("myOtherRoute"));
        Assertions.assertTrue((boolean)yaml.contains("direct:start"));
        Assertions.assertTrue((boolean)yaml.contains("mock:result"));
        Assertions.assertTrue((boolean)yaml.contains("seda:bar?size=1234&multipleConsumers=true"));
        Assertions.assertTrue((boolean)yaml.contains("ref:bar"));
        Assertions.assertTrue((boolean)yaml.contains("expression: bar"));
    }

    @Test
    public void testDumpAsYamlUriAsParameters() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        String yaml = (String)mbeanServer.invoke(on, "dumpRoutesAsYaml", new Object[]{true, true}, new String[]{"boolean", "boolean"});
        Assertions.assertNotNull((Object)yaml);
        this.log.info(yaml);
        Assertions.assertTrue((boolean)yaml.contains("route"));
        Assertions.assertTrue((boolean)yaml.contains("myRoute"));
        Assertions.assertTrue((boolean)yaml.contains("myOtherRoute"));
        Assertions.assertTrue((boolean)yaml.contains("direct"));
        Assertions.assertTrue((boolean)yaml.contains("name: start"));
        Assertions.assertTrue((boolean)yaml.contains("mock"));
        Assertions.assertTrue((boolean)yaml.contains("name: result"));
        Assertions.assertTrue((boolean)yaml.contains("ref"));
        Assertions.assertTrue((boolean)yaml.contains("name: bar"));
        Assertions.assertTrue((boolean)yaml.contains("seda"));
        Assertions.assertTrue((boolean)yaml.contains("name: bar"));
        Assertions.assertTrue((boolean)yaml.contains("parameters:"));
        Assertions.assertTrue((boolean)yaml.contains("size: 1234"));
        Assertions.assertTrue((boolean)yaml.contains("multipleConsumers: true"));
        Assertions.assertTrue((boolean)yaml.contains("expression: bar"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Properties props = new Properties();
                props.put("result", "mock:result");
                ManagedCamelContextDumpRoutesAsYamlTest.this.context.getPropertiesComponent().setOverrideProperties(props);
                Endpoint bar = ManagedCamelContextDumpRoutesAsYamlTest.this.context.getEndpoint("mock:bar");
                this.bindToRegistry("bar", bar);
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").log("Got ${body}")).to("{{result}}");
                ((ExpressionNode)((FilterDefinition)this.from("seda:bar?size=1234&multipleConsumers=true").routeId("myOtherRoute").filter().header("bar")).to("ref:bar")).end();
            }
        };
    }
}

