/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCamelContextDumpRouteTemplatesAsXmlTest
extends ManagementTestSupport {
    @Test
    public void testDumpAsXml() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        String xml = (String)mbeanServer.invoke(on, "dumpRouteTemplatesAsXml", null, null);
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("routeTemplate"));
        Assertions.assertTrue((boolean)xml.contains("myTemplate"));
        Assertions.assertTrue((boolean)xml.contains("<templateParameter name=\"foo\""));
        Assertions.assertTrue((boolean)xml.contains("<templateParameter name=\"bar\""));
        Assertions.assertTrue((boolean)xml.contains("direct:{{foo}}"));
        Assertions.assertTrue((boolean)xml.contains("myOtherTemplate"));
        Assertions.assertTrue((boolean)xml.contains("<templateParameter name=\"aaa\""));
        Assertions.assertTrue((boolean)xml.contains("<header>{{aaa}}</header>"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").log("Got ${body}")).to("{{bar}}");
                ((ExpressionNode)((FilterDefinition)this.routeTemplate("myOtherTemplate").templateParameter("aaa").from("seda:bar").filter().header("{{aaa}}")).to("ref:bar")).end();
            }
        };
    }
}

