/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisabledOnOs(value={OS.AIX})
public class ManagedTransformerRegistryTest
extends ManagementTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedTransformerRegistryTest.class);

    @Test
    public void testManageTransformerRegistry() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("DefaultTransformerRegistry")) continue;
            on = name;
            break;
        }
        Assertions.assertNotNull(on, (String)"Should have found TransformerRegistry");
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumCacheSize");
        Assertions.assertEquals((int)1000, (int)max);
        Integer current = (Integer)mbeanServer.getAttribute(on, "Size");
        Assertions.assertEquals((int)2, (int)current);
        current = (Integer)mbeanServer.getAttribute(on, "StaticSize");
        Assertions.assertEquals((int)2, (int)current);
        current = (Integer)mbeanServer.getAttribute(on, "DynamicSize");
        Assertions.assertEquals((int)0, (int)current);
        String source = (String)mbeanServer.getAttribute(on, "Source");
        Assertions.assertTrue((boolean)source.startsWith("TransformerRegistry"));
        Assertions.assertTrue((boolean)source.endsWith("capacity: 1000]"));
        TabularData data = (TabularData)mbeanServer.invoke(on, "listTransformers", null, null);
        for (Object row : data.values()) {
            CompositeData composite = (CompositeData)row;
            String name = (String)composite.get("name");
            String from = (String)composite.get("from");
            String to = (String)composite.get("to");
            String description = (String)composite.get("description");
            boolean isStatic = (Boolean)composite.get("static");
            boolean isDynamic = (Boolean)composite.get("dynamic");
            LOG.info("[{}][{}][{}][{}][{}][{}]", new Object[]{name, from, to, isStatic, isDynamic, description});
            if (description.startsWith("ProcessorTransformer")) {
                Assertions.assertEquals(null, (Object)name);
                Assertions.assertEquals((Object)"xml:foo", (Object)from);
                Assertions.assertEquals((Object)"json:bar", (Object)to);
                continue;
            }
            if (description.startsWith("DataFormatTransformer")) {
                Assertions.assertEquals(null, (Object)name);
                Assertions.assertEquals((Object)("java:" + ManagedTransformerRegistryTest.class.getName()), (Object)from);
                Assertions.assertEquals((Object)"xml:test", (Object)to);
                continue;
            }
            if (description.startsWith("MyTransformer")) {
                Assertions.assertEquals((Object)"custom", (Object)name);
                Assertions.assertEquals((Object)"camel:any", (Object)from);
                Assertions.assertEquals((Object)"camel:any", (Object)to);
                continue;
            }
            Assertions.fail((String)("Unexpected transformer:" + description));
        }
        Assertions.assertEquals((int)2, (int)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.transformer().fromType("xml:foo").toType("json:bar").withUri("direct:transformer");
                this.transformer().name("custom").withJava(MyTransformer.class);
                this.from("direct:start").to("mock:result");
            }
        };
    }

    public static class MyTransformer
    extends Transformer {
        public void transform(Message message, DataType from, DataType to) throws Exception {
        }
    }
}

