/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedThrottlerTest
extends ManagementTestSupport {
    @Test
    public void testManageThrottler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(10);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName throttlerName = this.getCamelObjectName("processors", "mythrottler");
        ObjectName routeName = this.getCamelObjectName("routes", "route1");
        mbeanServer.invoke(routeName, "reset", null, null);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message " + i));
        }
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)10L, (long)completed);
        Long timePeriod = (Long)mbeanServer.getAttribute(throttlerName, "TimePeriodMillis");
        Assertions.assertEquals((long)250L, (long)timePeriod);
        Long total = (Long)mbeanServer.getAttribute(routeName, "TotalProcessingTime");
        Assertions.assertTrue((total < 1000L ? 1 : 0) != 0, (String)("Should take at most 1.0 sec: was " + total));
        mbeanServer.setAttribute(throttlerName, new Attribute("MaximumRequestsPerPeriod", 2L));
        mbeanServer.invoke(routeName, "reset", null, null);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message " + i));
        }
        Long period = (Long)mbeanServer.getAttribute(throttlerName, "MaximumRequestsPerPeriod");
        Assertions.assertNotNull((Object)period);
        Assertions.assertEquals((long)2L, (long)period);
        completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)10L, (long)completed);
        total = (Long)mbeanServer.getAttribute(routeName, "TotalProcessingTime");
        Assertions.assertTrue((total > 1000L ? 1 : 0) != 0, (String)("Should be around 1 sec now: was " + total));
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testThrottleVisableViaJmx() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName routeName = this.getCamelObjectName("routes", "route2");
        mbeanServer.invoke(routeName, "reset", null, null);
        this.getMockEndpoint("mock:end").expectedMessageCount(10);
        NotifyBuilder notifier = new NotifyBuilder((CamelContext)this.context).from("seda:throttleCount").whenReceived(5).create();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCount", (Object)("Message " + i));
        }
        Assertions.assertTrue((boolean)notifier.matches(2L, TimeUnit.SECONDS));
        this.assertMockEndpointsSatisfied();
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)10L, (long)completed);
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testThrottleAsyncVisableViaJmx() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName routeName = this.getCamelObjectName("routes", "route3");
        mbeanServer.invoke(routeName, "reset", null, null);
        this.getMockEndpoint("mock:endAsync").expectedMessageCount(10);
        NotifyBuilder notifier = new NotifyBuilder((CamelContext)this.context).from("seda:throttleCountAsync").whenReceived(5).create();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountAsync", (Object)("Message " + i));
        }
        Assertions.assertTrue((boolean)notifier.matches(2L, TimeUnit.SECONDS));
        this.assertMockEndpointsSatisfied();
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)10L, (long)completed);
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testThrottleAsyncExceptionVisableViaJmx() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName routeName = this.getCamelObjectName("routes", "route4");
        mbeanServer.invoke(routeName, "reset", null, null);
        this.getMockEndpoint("mock:endAsyncException").expectedMessageCount(10);
        NotifyBuilder notifier = new NotifyBuilder((CamelContext)this.context).from("seda:throttleCountAsyncException").whenReceived(5).create();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountAsyncException", (Object)("Message " + i));
        }
        Assertions.assertTrue((boolean)notifier.matches(2L, TimeUnit.SECONDS));
        this.assertMockEndpointsSatisfied();
        Thread.sleep(500L);
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed);
    }

    @Test
    public void testRejectedExecution() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName routeName = this.getCamelObjectName("routes", "route2");
        mbeanServer.invoke(routeName, "reset", null, null);
        MockEndpoint mock = this.getMockEndpoint("mock:endAsyncReject");
        mock.expectedMessageCount(1);
        MockEndpoint exceptionMock = this.getMockEndpoint("mock:rejectedExceptionEndpoint1");
        exceptionMock.expectedMessageCount(9);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountRejectExecution", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRejectedExecutionCallerRuns() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName routeName = this.getCamelObjectName("routes", "route2");
        mbeanServer.invoke(routeName, "reset", null, null);
        MockEndpoint mock = this.getMockEndpoint("mock:endAsyncRejectCallerRuns");
        mock.expectedMessageCount(10);
        MockEndpoint exceptionMock = this.getMockEndpoint("mock:rejectedExceptionEndpoint");
        exceptionMock.expectedMessageCount(0);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountRejectExecutionCallerRuns", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        final ScheduledThreadPoolExecutor badService = new ScheduledThreadPoolExecutor(1){

            @Override
            public <V> ScheduledFuture<V> schedule(Callable<V> command, long delay, TimeUnit unit) {
                throw new RejectedExecutionException();
            }
        };
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").id("route1")).to("log:foo")).throttle(10L).timePeriodMillis(250L).id("mythrottler").to("mock:result");
                ((RouteDefinition)this.from("seda:throttleCount").id("route2")).throttle(1L).timePeriodMillis(250L).id("mythrottler2").to("mock:end");
                ((RouteDefinition)this.from("seda:throttleCountAsync").id("route3")).throttle(1L).asyncDelayed().timePeriodMillis(250L).id("mythrottler3").to("mock:endAsync");
                ((ExpressionNode)((RouteDefinition)this.from("seda:throttleCountAsyncException").id("route4")).throttle(1L).asyncDelayed().timePeriodMillis(250L).id("mythrottler4").to("mock:endAsyncException")).process(exchange -> {
                    throw new RuntimeException("Fail me");
                });
                ((OnExceptionDefinition)((RouteDefinition)this.from("seda:throttleCountRejectExecutionCallerRuns").id("route5")).onException(RejectedExecutionException.class).to("mock:rejectedExceptionEndpoint1")).end().throttle(1L).timePeriodMillis(250L).asyncDelayed().executorService((ExecutorService)badService).callerRunsWhenRejected(true).id("mythrottler5").to("mock:endAsyncRejectCallerRuns");
                ((OnExceptionDefinition)((RouteDefinition)this.from("seda:throttleCountRejectExecution").id("route6")).onException(RejectedExecutionException.class).to("mock:rejectedExceptionEndpoint1")).end().throttle(1L).timePeriodMillis(250L).asyncDelayed().executorService((ExecutorService)badService).callerRunsWhenRejected(false).id("mythrottler6").to("mock:endAsyncReject");
            }
        };
    }
}

