/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.NonManagedService;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedNonManagedServiceTest
extends ManagementTestSupport {
    private static final int SERVICES = 14;

    @Test
    public void testService() throws Exception {
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        MyService service = new MyService();
        for (LifecycleStrategy strategy : this.context.getLifecycleStrategies()) {
            strategy.onServiceAdd((CamelContext)this.context, (Service)service, null);
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        Assertions.assertEquals((int)15, (int)set.size());
    }

    @Test
    public void testNonManagedService() throws Exception {
        this.context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        MyNonService service = new MyNonService();
        for (LifecycleStrategy strategy : this.context.getLifecycleStrategies()) {
            strategy.onServiceAdd((CamelContext)this.context, (Service)service, null);
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        Assertions.assertEquals((int)14, (int)set.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }

    private static final class MyService
    extends ServiceSupport {
        private MyService() {
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }

    private static final class MyNonService
    extends ServiceSupport
    implements NonManagedService {
        private MyNonService() {
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

