/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class BacklogTracerIdOnAllNodesTest
extends ManagementTestSupport {
    @Test
    public void testBacklogTracerEventMessage() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        Assertions.assertEquals((int)1000, (int)size, (String)"Should be 1000");
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:camel").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:end").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        List fooExchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List camelExchanges = this.getMockEndpoint("mock:camel").getReceivedExchanges();
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        Assertions.assertNotNull((Object)route);
        ChoiceDefinition choice = (ChoiceDefinition)route.getOutputs().get(0);
        Assertions.assertNotNull((Object)choice.getId());
        WhenDefinition when = (WhenDefinition)choice.getOutputs().get(0);
        Assertions.assertNotNull((Object)when.getId());
        LogDefinition log1 = (LogDefinition)when.getOutputs().get(0);
        Assertions.assertNotNull((Object)log1.getId());
        ToDefinition to1 = (ToDefinition)when.getOutputs().get(1);
        Assertions.assertEquals((Object)"camel", (Object)to1.getId());
        OtherwiseDefinition other = (OtherwiseDefinition)choice.getOutputs().get(1);
        Assertions.assertNotNull((Object)other.getId());
        LogDefinition log2 = (LogDefinition)other.getOutputs().get(0);
        Assertions.assertNotNull((Object)log2.getId());
        Assertions.assertNotEquals((Object)log1.getId(), (Object)log2.getId());
        ToDefinition to2 = (ToDefinition)other.getOutputs().get(1);
        Assertions.assertNotNull((Object)to2.getId());
        Assertions.assertNotEquals((Object)to1.getId(), (Object)to2.getId());
        ToDefinition to3 = (ToDefinition)other.getOutputs().get(2);
        Assertions.assertEquals((Object)"foo", (Object)to3.getId());
        ToDefinition to4 = (ToDefinition)route.getOutputs().get(1);
        Assertions.assertEquals((Object)"end", (Object)to4.getId());
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{to2.getId()}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)1, (int)events.size());
        BacklogTracerEventMessage event1 = (BacklogTracerEventMessage)events.get(0);
        Assertions.assertEquals((Object)to2.getId(), (Object)event1.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)fooExchanges.get(0)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n      <body type=\"java.lang.String\">Hello World</body>\n    </message>"), (Object)event1.getMessageAsXml());
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"camel"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)1, (int)events.size());
        event1 = (BacklogTracerEventMessage)events.get(0);
        Assertions.assertEquals((Object)"camel", (Object)event1.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)camelExchanges.get(0)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n      <body type=\"java.lang.String\">Hello Camel</body>\n    </message>"), (Object)event1.getMessageAsXml());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerIdOnAllNodesTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                BacklogTracerIdOnAllNodesTest.this.context.setBacklogTracingStandby(true);
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().contains((Object)"Camel")).log("A Camel message")).to("mock:camel")).id("camel")).otherwise().log("Some other kind of message")).to("mock:other")).to("mock:foo")).id("foo")).end().to("mock:end").id("end");
            }
        };
    }
}

