/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedThreadPoolProfileTest
extends ManagementTestSupport {
    @Test
    public void testManagedThreadPool() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("threadpools", "mythreads(threads)");
        Boolean shutdown = (Boolean)mbeanServer.getAttribute(on, "Shutdown");
        Assertions.assertEquals((Object)false, (Object)shutdown);
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        Assertions.assertEquals((int)5, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        Assertions.assertEquals((int)15, (int)maxPoolSize);
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        Assertions.assertEquals((int)0, (int)poolSize);
        Long keepAlive = (Long)mbeanServer.getAttribute(on, "KeepAliveTime");
        Assertions.assertEquals((int)25, (int)keepAlive.intValue());
        Boolean allow = (Boolean)mbeanServer.getAttribute(on, "AllowCoreThreadTimeout");
        Assertions.assertEquals((Object)true, (Object)allow);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String id = (String)mbeanServer.getAttribute(on, "Id");
        Assertions.assertEquals((Object)"mythreads", (Object)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        Assertions.assertEquals((Object)"threads", (Object)source);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertTrue((boolean)routeId.matches("route[0-9]+"));
        String profileId = (String)mbeanServer.getAttribute(on, "ThreadPoolProfileId");
        Assertions.assertEquals((Object)"custom", (Object)profileId);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ThreadPoolProfile profile = new ThreadPoolProfile("custom");
                profile.setPoolSize(Integer.valueOf(5));
                profile.setMaxPoolSize(Integer.valueOf(15));
                profile.setKeepAliveTime(Long.valueOf(25L));
                profile.setMaxQueueSize(Integer.valueOf(250));
                profile.setAllowCoreThreadTimeOut(Boolean.valueOf(true));
                profile.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
                ManagedThreadPoolProfileTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(profile);
                ((ThreadsDefinition)this.from("direct:start").threads().id("mythreads")).executorService("custom").to("mock:result");
            }
        };
    }
}

