/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRandomLoadBalancerTest
extends ManagementTestSupport {
    @Test
    public void testManageRandomLoadBalancer() throws Exception {
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "mysend");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        Assertions.assertEquals((int)2, (int)size);
        String last = (String)mbeanServer.getAttribute(on, "LastChosenProcessorId");
        Assertions.assertTrue(("foo".equals(last) || "bar".equals(last) ? 1 : 0) != 0);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").loadBalance().random().id("mysend")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

