/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCamelContextDumpRoutesAsXmlTest
extends ManagementTestSupport {
    @Test
    public void testDumpAsXml() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", null, null);
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("route"));
        Assertions.assertTrue((boolean)xml.contains("myRoute"));
        Assertions.assertTrue((boolean)xml.contains("myOtherRoute"));
        Assertions.assertTrue((boolean)xml.contains("direct:start"));
        Assertions.assertTrue((boolean)xml.contains("{{result}}"));
        Assertions.assertTrue((boolean)xml.contains("seda:bar"));
        Assertions.assertTrue((boolean)xml.contains("ref:bar"));
        Assertions.assertTrue((boolean)xml.contains("<header>bar</header>"));
    }

    @Test
    public void testDumpAsXmlResolvePlaceholder() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", new Object[]{true}, new String[]{"boolean"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("route"));
        Assertions.assertTrue((boolean)xml.contains("myRoute"));
        Assertions.assertTrue((boolean)xml.contains("myOtherRoute"));
        Assertions.assertTrue((boolean)xml.contains("direct:start"));
        Assertions.assertTrue((boolean)xml.contains("mock:result"));
        Assertions.assertTrue((boolean)xml.contains("seda:bar"));
        Assertions.assertTrue((boolean)xml.contains("ref:bar"));
        Assertions.assertTrue((boolean)xml.contains("<header>bar</header>"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Properties props = new Properties();
                props.put("result", "mock:result");
                ManagedCamelContextDumpRoutesAsXmlTest.this.context.getPropertiesComponent().setOverrideProperties(props);
                Endpoint bar = ManagedCamelContextDumpRoutesAsXmlTest.this.context.getEndpoint("mock:bar");
                this.bindToRegistry("bar", bar);
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").log("Got ${body}")).to("{{result}}");
                ((ExpressionNode)((FilterDefinition)this.from("seda:bar").routeId("myOtherRoute").filter().header("bar")).to("ref:bar")).end();
            }
        };
    }
}

