/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedAggregateProcessorMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.DefaultAggregateController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
@DisabledOnOs(value={OS.AIX})
public class ManagedAggregateControllerTest
extends ManagementTestSupport {
    private AggregateController controller = new DefaultAggregateController();

    @Test
    public void testForceCompletionOfAll() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "myAggregator");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"2");
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(2);
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceivedInAnyOrder(new Object[]{"test1test3", "test2test4"});
        this.getMockEndpoint("mock:aggregated").expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"force");
        Integer pending = (Integer)mbeanServer.invoke(on, "aggregationRepositoryGroups", null, null);
        Assertions.assertEquals((int)2, (int)pending);
        Integer groups = (Integer)mbeanServer.invoke(on, "forceCompletionOfAllGroups", null, null);
        Assertions.assertEquals((int)2, (int)groups);
        this.assertMockEndpointsSatisfied();
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)4L, (long)completed);
        completed = (Long)mbeanServer.getAttribute(on, "TotalCompleted");
        Assertions.assertEquals((long)2L, (long)completed);
        Long in = (Long)mbeanServer.getAttribute(on, "TotalIn");
        Assertions.assertEquals((long)4L, (long)in);
        Long byForced = (Long)mbeanServer.getAttribute(on, "CompletedByForce");
        Assertions.assertEquals((long)2L, (long)byForced);
        Long bySize = (Long)mbeanServer.getAttribute(on, "CompletedBySize");
        Assertions.assertEquals((long)0L, (long)bySize);
        Integer size = (Integer)mbeanServer.getAttribute(on, "CompletionSize");
        Assertions.assertEquals((long)10L, (long)size.longValue());
        String lan = (String)mbeanServer.getAttribute(on, "CorrelationExpressionLanguage");
        Assertions.assertEquals((Object)"header", (Object)lan);
        String cor = (String)mbeanServer.getAttribute(on, "CorrelationExpression");
        Assertions.assertEquals((Object)"id", (Object)cor);
        Integer inflight = (Integer)mbeanServer.getAttribute(on, "InProgressCompleteExchanges");
        Assertions.assertEquals((int)0, (int)inflight);
        pending = (Integer)mbeanServer.invoke(on, "aggregationRepositoryGroups", null, null);
        Assertions.assertEquals((int)0, (int)pending);
    }

    @Test
    public void testForceCompletionOfGroup() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "myAggregator");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"2");
        this.assertMockEndpointsSatisfied();
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(1);
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceivedInAnyOrder(new Object[]{"test1test3"});
        this.getMockEndpoint("mock:aggregated").expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"force");
        Integer pending = (Integer)mbeanServer.invoke(on, "aggregationRepositoryGroups", null, null);
        Assertions.assertEquals((int)2, (int)pending);
        Integer groups = (Integer)mbeanServer.invoke(on, "forceCompletionOfGroup", new Object[]{"1"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((int)1, (int)groups);
        this.assertMockEndpointsSatisfied();
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)4L, (long)completed);
        completed = (Long)mbeanServer.getAttribute(on, "TotalCompleted");
        Assertions.assertEquals((long)1L, (long)completed);
        Long in = (Long)mbeanServer.getAttribute(on, "TotalIn");
        Assertions.assertEquals((long)4L, (long)in);
        Long byForced = (Long)mbeanServer.getAttribute(on, "CompletedByForce");
        Assertions.assertEquals((long)1L, (long)byForced);
        Long bySize = (Long)mbeanServer.getAttribute(on, "CompletedBySize");
        Assertions.assertEquals((long)0L, (long)bySize);
        Integer size = (Integer)mbeanServer.getAttribute(on, "CompletionSize");
        Assertions.assertEquals((long)10L, (long)size.longValue());
        String lan = (String)mbeanServer.getAttribute(on, "CorrelationExpressionLanguage");
        Assertions.assertEquals((Object)"header", (Object)lan);
        String cor = (String)mbeanServer.getAttribute(on, "CorrelationExpression");
        Assertions.assertEquals((Object)"id", (Object)cor);
        Integer inflight = (Integer)mbeanServer.getAttribute(on, "InProgressCompleteExchanges");
        Assertions.assertEquals((int)0, (int)inflight);
        pending = (Integer)mbeanServer.invoke(on, "aggregationRepositoryGroups", null, null);
        Assertions.assertEquals((int)1, (int)pending);
        ManagedAggregateProcessorMBean client = (ManagedAggregateProcessorMBean)((ManagedCamelContext)this.context.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class)).getManagedProcessor("myAggregator", ManagedAggregateProcessorMBean.class);
        Assertions.assertNotNull((Object)client);
        Assertions.assertEquals((long)1L, (long)client.getCompletedByForce());
        Assertions.assertEquals((long)4L, (long)client.getTotalIn());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((AggregateDefinition)this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).aggregateController(ManagedAggregateControllerTest.this.controller).id("myAggregator")).completionSize(10).to("mock:aggregated");
            }
        };
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body1 = (String)oldExchange.getIn().getBody(String.class);
            String body2 = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body1 + body2));
            return oldExchange;
        }
    }
}

