/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.spi.NodeIdFactory;

public abstract class ManagementTestSupport
extends ContextTestSupport {
    protected boolean useJmx() {
        return true;
    }

    protected boolean canRunOnThisPlatform() {
        return !ManagementTestSupport.isPlatform((String)"aix");
    }

    protected MBeanServer getMBeanServer() {
        return this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
    }

    protected <T> T invoke(MBeanServerConnection server, ObjectName name, String operationName) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return (T)server.invoke(name, operationName, null, null);
    }

    protected <T> T invoke(MBeanServerConnection server, ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return (T)server.invoke(name, operationName, params, signature);
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext ctx = super.createCamelContext();
        ((AbstractCamelContext)ctx).setNodeIdFactory(new NodeIdFactory(){
            private AtomicInteger counter = new AtomicInteger();

            public String createId(NamedNode definition) {
                return definition.getShortName() + this.counter.incrementAndGet();
            }
        });
        return ctx;
    }

    public ObjectName getContextObjectName() throws MalformedObjectNameException {
        return this.getCamelObjectName("context", this.context.getName());
    }

    public ObjectName getCamelObjectName(String type, String name) throws MalformedObjectNameException {
        String quote = switch (type) {
            case "context", "components", "endpoints", "processors", "routes", "threadpools", "steps" -> "\"";
            default -> "";
        };
        String on = "org.apache.camel:context=" + this.context.getManagementName() + ",type=" + type + ",name=" + quote + name + quote;
        return ObjectName.getInstance(on);
    }
}

