/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.impl.engine.PooledExchangeFactory;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ExchangeFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
public class ManagedPooledExchangeTest
extends ManagementTestSupport {
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicReference<Exchange> ref = new AtomicReference();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PooledExchangeFactory pef = new PooledExchangeFactory();
        pef.setStatisticsEnabled(true);
        pef.setCapacity(123);
        ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).setExchangeFactory((ExchangeFactory)pef);
        return context;
    }

    @Test
    public void testSameExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedPropertyValuesReceivedInAnyOrder("myprop", new Object[]{1, 3, 5});
        mock.expectedHeaderValuesReceivedInAnyOrder("myheader", new Object[]{2, 4, 6});
        ((MockValueBuilder)mock.message(0).header("first")).isEqualTo((Object)true);
        ((MockValueBuilder)mock.message(1).header("first")).isNull();
        ((MockValueBuilder)mock.message(2).header("first")).isNull();
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "DefaultExchangeFactoryManager");
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Integer con = (Integer)mbeanServer.getAttribute(on, "ConsumerCounter");
        Assertions.assertEquals((int)1, (int)con);
        Integer cap = (Integer)mbeanServer.getAttribute(on, "Capacity");
        Assertions.assertEquals((int)123, (int)cap);
        con = (Integer)mbeanServer.getAttribute(on, "TotalPooled");
        Assertions.assertEquals((int)1, (int)con);
        Long num = (Long)mbeanServer.getAttribute(on, "TotalCreated");
        Assertions.assertEquals((int)1, (int)num.intValue());
        num = (Long)mbeanServer.getAttribute(on, "TotalAcquired");
        Assertions.assertEquals((int)2, (int)num.intValue());
        num = (Long)mbeanServer.getAttribute(on, "TotalReleased");
        Assertions.assertEquals((int)3, (int)num.intValue());
        num = (Long)mbeanServer.getAttribute(on, "TotalDiscarded");
        Assertions.assertEquals((int)0, (int)num.intValue());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("timer:foo?period=1&delay=1&repeatCount=3").noAutoStartup().setProperty("myprop", ManagedPooledExchangeTest.this.counter::incrementAndGet)).setHeader("myheader", ManagedPooledExchangeTest.this.counter::incrementAndGet)).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Exchange old = ManagedPooledExchangeTest.this.ref.get();
                        if (old == null) {
                            ManagedPooledExchangeTest.this.ref.set(exchange);
                            exchange.getMessage().setHeader("first", (Object)true);
                        } else {
                            Assertions.assertSame((Object)old, (Object)exchange);
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

