/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoveEventNotifierTest
extends ContextTestSupport {
    private static List<CamelEvent> events = new ArrayList<CamelEvent>();
    private EventNotifier notifier;

    @BeforeEach
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createRegistry());
        this.notifier = new EventNotifierSupport(){

            public void notify(CamelEvent event) throws Exception {
                events.add(event);
            }
        };
        context.getManagementStrategy().addEventNotifier(this.notifier);
        return context;
    }

    @Test
    public void testRemove() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)14, (int)events.size());
        this.context.getManagementStrategy().removeEventNotifier(this.notifier);
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)14, (int)events.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

