/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ManagedSuspendedServiceTest
extends ManagementTestSupport {
    @BeforeEach
    public void setUp() throws Exception {
        ManagedSuspendedServiceTest.deleteDirectory((String)"target/data/suspended");
        super.setUp();
    }

    @Test
    public void testConsumeSuspendAndResumeFile() throws Exception {
        if (ManagedSuspendedServiceTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        Assertions.assertEquals((Object)true, (Object)registered, (String)"Should be registered");
        Boolean ss = (Boolean)mbeanServer.getAttribute(on, "SupportSuspension");
        Assertions.assertEquals((Object)true, (Object)ss);
        Boolean suspended = (Boolean)mbeanServer.getAttribute(on, "Suspended");
        Assertions.assertEquals((Object)false, (Object)suspended);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/data/suspended", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader("file://target/data/suspended", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> {
            Boolean bool = (Boolean)mbeanServer.getAttribute(on, "Suspended");
            Assertions.assertEquals((Object)true, (Object)bool);
        });
        String[] files = new File("target/data/suspended/").list();
        Assertions.assertNotNull((Object)files);
        Assertions.assertEquals((int)1, (int)files.length, (String)"The file should exists");
        mock.reset();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resume", null, null);
        this.assertMockEndpointsSatisfied();
        suspended = (Boolean)mbeanServer.getAttribute(on, "Suspended");
        Assertions.assertEquals((Object)false, (Object)suspended);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> {
            String[] names = new File("target/data/suspended/").list();
            Assertions.assertNotNull((Object)names);
            Assertions.assertEquals((int)0, (int)names.length, (String)"The file should exists");
        });
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MyPolicy myPolicy = new MyPolicy();
                ((RouteDefinition)this.from("file://target/data/suspended?initialDelay=0&delay=10&maxMessagesPerPoll=1&delete=true").routePolicy(new RoutePolicy[]{myPolicy}).id("myRoute")).to("mock:result");
            }
        };
    }

    private static class MyPolicy
    extends RoutePolicySupport {
        private int counter;

        private MyPolicy() {
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            if (this.counter++ == 0) {
                try {
                    super.suspendOrStopConsumer(route.getConsumer());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
    }
}

