/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedSendProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedStepMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.StepDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedStepTest
extends ManagementTestSupport {
    @Test
    public void testManageStep() throws Exception {
        if (ManagedStepTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=steps,name=\"foo\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String stepId = (String)mbeanServer.getAttribute(on, "StepId");
        Assertions.assertEquals((Object)"foo", (Object)stepId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        ManagedCamelContext mcc = (ManagedCamelContext)this.context.getExtension(ManagedCamelContext.class);
        ManagedStepMBean step = mcc.getManagedStep("foo");
        Assertions.assertEquals((Object)"foo", (Object)step.getProcessorId());
        Assertions.assertEquals((long)1L, (long)step.getExchangesCompleted());
        String xml = mcc.getManagedCamelContext().dumpStepStatsAsXml(false);
        Assertions.assertNotNull((Object)xml);
        Assertions.assertTrue((boolean)xml.contains("<stepStat id=\"foo\""));
        xml = mcc.getManagedCamelContext().dumpStepStatsAsXml(true);
        Assertions.assertNotNull((Object)xml);
        Assertions.assertTrue((boolean)xml.contains("<stepStat id=\"foo\""));
        ManagedSendProcessorMBean mp = (ManagedSendProcessorMBean)mcc.getManagedProcessor("abc", ManagedSendProcessorMBean.class);
        Assertions.assertNotNull((Object)mp);
        Assertions.assertEquals((Object)"route1", (Object)mp.getRouteId());
        Assertions.assertEquals((Object)"foo", (Object)mp.getStepId());
        Assertions.assertEquals((Object)"log://foo", (Object)mp.getDestination());
        mp = (ManagedSendProcessorMBean)mcc.getManagedProcessor("def", ManagedSendProcessorMBean.class);
        Assertions.assertNotNull((Object)mp);
        Assertions.assertEquals((Object)"route1", (Object)mp.getRouteId());
        Assertions.assertEquals((Object)"foo", (Object)mp.getStepId());
        Assertions.assertEquals((Object)"mock://foo", (Object)mp.getDestination());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((StepDefinition)((StepDefinition)((StepDefinition)((StepDefinition)this.from("direct:start").routeId("route1").step("foo").to("log:foo")).id("abc")).to("mock:foo")).id("def")).end().to("mock:result");
            }
        };
    }
}

