/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedSendProcessorTest
extends ManagementTestSupport {
    @Test
    public void testManageSendProcessor() throws Exception {
        if (ManagedSendProcessorTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String destination = (String)mbeanServer.getAttribute(on, "Destination");
        Assertions.assertEquals((Object)"mock://result", (Object)destination);
        String pattern = (String)mbeanServer.getAttribute(on, "MessageExchangePattern");
        Assertions.assertNull((Object)pattern);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("mock:result")).id("mysend");
                this.from("direct:foo").to("mock:foo");
            }
        };
    }
}

