/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedRouteStopTest
extends ManagementTestSupport {
    @Test
    public void testStopRoute() throws Exception {
        if (ManagedRouteStopTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        Assertions.assertEquals((Object)true, (Object)registered, (String)"Should be registered");
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        Assertions.assertEquals((Object)"direct://start", (Object)uri);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        Assertions.assertNotNull((Object)uptime);
        this.log.info("Uptime: {}", (Object)uptime);
        long uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        Assertions.assertTrue((uptimeMillis > 0L ? 1 : 0) != 0);
        mbeanServer.invoke(on, "stop", null, null);
        registered = mbeanServer.isRegistered(on);
        Assertions.assertEquals((Object)true, (Object)registered, (String)"Should be registered");
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)state, (String)"Should be stopped");
        uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        Assertions.assertEquals((Object)"", (Object)uptime);
        uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        Assertions.assertEquals((long)0L, (long)uptimeMillis);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").delayer(10L).to("log:foo")).to("mock:result");
            }
        };
    }
}

