/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.MulticastDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedMulticastTest
extends ManagementTestSupport {
    @Test
    public void testMulticast() throws Exception {
        if (ManagedMulticastTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:a").expectedMessageCount(3);
        this.getMockEndpoint("mock:b").expectedMessageCount(3);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://a\"");
        Long queueSize = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        Assertions.assertEquals((int)3, (int)queueSize.intValue());
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://b\"");
        queueSize = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        Assertions.assertEquals((int)3, (int)queueSize.intValue());
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"myMulticast\"");
        mbeanServer.isRegistered(name);
        Long total = (Long)mbeanServer.getAttribute(name, "ExchangesTotal");
        Assertions.assertEquals((int)3, (int)total.intValue());
        Boolean parallel = (Boolean)mbeanServer.getAttribute(name, "ParallelProcessing");
        Assertions.assertEquals((Object)false, (Object)parallel);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)((MulticastDefinition)this.from("direct:start").routeId("foo").multicast().id("myMulticast")).to("mock:a")).to("mock:b");
            }
        };
    }
}

