/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Collection;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.impl.health.DefaultHealthCheckRegistry;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedHealthCheckTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        DefaultHealthCheckRegistry registry = new DefaultHealthCheckRegistry();
        registry.setCamelContext(context);
        Object hc = registry.resolveById("context");
        registry.register(hc);
        context.setExtension(HealthCheckRegistry.class, (Object)registry);
        return context;
    }

    @Test
    public void testHealthCheck() throws Exception {
        if (ManagedHealthCheckTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=health,name=DefaultHealthCheck");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean up = (Boolean)mbeanServer.getAttribute(on, "Healthy");
        Assertions.assertTrue((boolean)up);
        up = (Boolean)mbeanServer.getAttribute(on, "HealthyReadiness");
        Assertions.assertTrue((boolean)up);
        up = (Boolean)mbeanServer.getAttribute(on, "HealthyLiveness");
        Assertions.assertTrue((boolean)up);
        TabularData data = (TabularData)mbeanServer.invoke(on, "details", null, null);
        Assertions.assertEquals((int)1, (int)data.size());
        Collection ids = (Collection)mbeanServer.invoke(on, "getHealthChecksIDs", null, null);
        Assertions.assertEquals((int)1, (int)ids.size());
        Assertions.assertEquals((Object)"context", ids.iterator().next());
    }

    @Test
    public void testHealthCheckDisableById() throws Exception {
        if (ManagedHealthCheckTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        ((HealthCheckRegistry)this.context.getExtension(HealthCheckRegistry.class)).register((Object)new AbstractHealthCheck("custom", "myCheck"){

            protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
                builder.down();
            }
        });
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=health,name=DefaultHealthCheck");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean up = (Boolean)mbeanServer.getAttribute(on, "Healthy");
        Assertions.assertFalse((boolean)up);
        Collection ids = (Collection)mbeanServer.invoke(on, "getHealthChecksIDs", null, null);
        Assertions.assertEquals((int)2, (int)ids.size());
        mbeanServer.invoke(on, "disableById", new Object[]{"myCheck"}, new String[]{"java.lang.String"});
        up = (Boolean)mbeanServer.getAttribute(on, "Healthy");
        Assertions.assertTrue((boolean)up);
        mbeanServer.invoke(on, "enableById", new Object[]{"myCheck"}, new String[]{"java.lang.String"});
        up = (Boolean)mbeanServer.getAttribute(on, "Healthy");
        Assertions.assertFalse((boolean)up);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

