/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.File;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.FileIdempotentRepository;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ManagedFileIdempotentClearTest
extends ManagementTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    private File store = new File("target/data/idempotentfilestore.dat");
    private IdempotentRepository repo;

    @Test
    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        if (ManagedFileIdempotentClearTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> names = mbeanServer.queryNames(new ObjectName("org.apache.camel:type=services,*"), null);
        ObjectName on = null;
        for (ObjectName name : names) {
            if (!name.toString().contains("FileIdempotentRepository")) continue;
            on = name;
            break;
        }
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String path = (String)mbeanServer.getAttribute(on, "FilePath");
        Assertions.assertEquals((Object)FileUtil.normalizePath((String)"target/data/idempotentfilestore.dat"), (Object)FileUtil.normalizePath((String)path));
        Integer size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        Assertions.assertEquals((int)1, (int)size);
        Assertions.assertFalse((boolean)this.repo.contains("1"));
        Assertions.assertFalse((boolean)this.repo.contains("2"));
        Assertions.assertFalse((boolean)this.repo.contains("3"));
        Assertions.assertTrue((boolean)this.repo.contains("4"));
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("3", "three");
        this.resultEndpoint.assertIsSatisfied();
        Assertions.assertTrue((boolean)this.repo.contains("1"));
        Assertions.assertTrue((boolean)this.repo.contains("2"));
        Assertions.assertTrue((boolean)this.repo.contains("3"));
        Assertions.assertTrue((boolean)this.repo.contains("4"));
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        Assertions.assertEquals((int)4, (int)size);
        mbeanServer.invoke(on, "clear", null, null);
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        Assertions.assertEquals((int)0, (int)size);
        Assertions.assertFalse((boolean)this.repo.contains("1"));
        Assertions.assertFalse((boolean)this.repo.contains("2"));
        Assertions.assertFalse((boolean)this.repo.contains("3"));
        Assertions.assertFalse((boolean)this.repo.contains("4"));
    }

    protected void sendMessage(Object messageId, Object body) {
        this.template.send(this.startEndpoint, exchange -> {
            Message in = exchange.getIn();
            in.setBody(body);
            in.setHeader("messageId", messageId);
        });
    }

    @BeforeEach
    public void setUp() throws Exception {
        if (this.store.exists()) {
            this.store.delete();
        }
        this.repo = FileIdempotentRepository.fileIdempotentRepository((File)this.store);
        this.repo.add("4");
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), ManagedFileIdempotentClearTest.this.repo).to("mock:result");
            }
        };
    }
}

