/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedCamelContextTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementNameStrategy().setNamePattern("19-#name#");
        return context;
    }

    @Test
    public void testManagedCamelContextClient() throws Exception {
        if (ManagedCamelContextTest.isPlatform((String)"aix")) {
            return;
        }
        ManagedCamelContextMBean client = ((ManagedCamelContext)this.context.getExtension(ManagedCamelContext.class)).getManagedCamelContext();
        Assertions.assertNotNull((Object)client);
        Assertions.assertEquals((Object)"camel-1", (Object)client.getCamelId());
        Assertions.assertEquals((Object)"Started", (Object)client.getState());
    }

    @Test
    public void testManagedCamelContext() throws Exception {
        if (ManagedCamelContextTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"camel-1", (Object)name);
        String managementName = (String)mbeanServer.getAttribute(on, "ManagementName");
        Assertions.assertEquals((Object)"19-camel-1", (Object)managementName);
        String level = (String)mbeanServer.getAttribute(on, "ManagementStatisticsLevel");
        Assertions.assertEquals((Object)"Default", (Object)level);
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        Assertions.assertNotNull((Object)uptime);
        long uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        Assertions.assertTrue((uptimeMillis > 0L ? 1 : 0) != 0);
        String status = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)"Started", (Object)status);
        Boolean messageHistory = (Boolean)mbeanServer.getAttribute(on, "MessageHistory");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)messageHistory);
        Boolean logMask = (Boolean)mbeanServer.getAttribute(on, "LogMask");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)logMask);
        Integer total = (Integer)mbeanServer.getAttribute(on, "TotalRoutes");
        Assertions.assertEquals((int)2, (int)total);
        Integer started = (Integer)mbeanServer.getAttribute(on, "StartedRoutes");
        Assertions.assertEquals((int)2, (int)started);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mbeanServer.invoke(on, "sendBody", new Object[]{"direct:start", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mbeanServer.invoke(on, "sendStringBody", new Object[]{"direct:start", "Hello World"}, new String[]{"java.lang.String", "java.lang.String"});
        this.assertMockEndpointsSatisfied();
        Object reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
        reply = mbeanServer.invoke(on, "requestStringBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.String"});
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
        this.resetMocks();
        mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        HashMap<String, Integer> headers = new HashMap<String, Integer>();
        headers.put("foo", 123);
        mbeanServer.invoke(on, "sendBodyAndHeaders", new Object[]{"direct:start", "Hello World", headers}, new String[]{"java.lang.String", "java.lang.Object", "java.util.Map"});
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        reply = mbeanServer.invoke(on, "requestBodyAndHeaders", new Object[]{"direct:start", "Hello World", headers}, new String[]{"java.lang.String", "java.lang.Object", "java.util.Map"});
        Assertions.assertEquals((Object)"Hello World", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Boolean can = (Boolean)mbeanServer.invoke(on, "canSendToEndpoint", new Object[]{"direct:start"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)true, (Object)can);
        can = (Boolean)mbeanServer.invoke(on, "canSendToEndpoint", new Object[]{"timer:foo"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)false, (Object)can);
        mbeanServer.invoke(on, "stop", null, null);
    }

    @Test
    public void testManagedCamelContextCreateEndpoint() throws Exception {
        if (ManagedCamelContextTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        Assertions.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        Object reply = mbeanServer.invoke(on, "createEndpoint", new Object[]{"seda:bar"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)reply);
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda:bar"));
        ObjectName seda = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=endpoints,name=\"seda://bar\"");
        boolean registered = mbeanServer.isRegistered(seda);
        Assertions.assertTrue((boolean)registered, (String)("Should be registered " + seda));
        reply = mbeanServer.invoke(on, "createEndpoint", new Object[]{"seda:bar"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)reply);
        registered = mbeanServer.isRegistered(seda);
        Assertions.assertTrue((boolean)registered, (String)("Should be registered " + seda));
    }

    @Test
    public void testManagedCamelContextRemoveEndpoint() throws Exception {
        if (ManagedCamelContextTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        Assertions.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        Object reply = mbeanServer.invoke(on, "createEndpoint", new Object[]{"seda:bar"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)reply);
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda:bar"));
        ObjectName seda = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=endpoints,name=\"seda://bar\"");
        boolean registered = mbeanServer.isRegistered(seda);
        Assertions.assertTrue((boolean)registered, (String)("Should be registered " + seda));
        Object num = mbeanServer.invoke(on, "removeEndpoints", new Object[]{"seda:*"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)1, (Object)num);
        Assertions.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        registered = mbeanServer.isRegistered(seda);
        Assertions.assertFalse((boolean)registered, (String)("Should not be registered " + seda));
        num = mbeanServer.invoke(on, "removeEndpoints", new Object[]{"seda:*"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)0, (Object)num);
        Assertions.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        registered = mbeanServer.isRegistered(seda);
        Assertions.assertFalse((boolean)registered, (String)("Should not be registered " + seda));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").delay(10L).to("mock:result");
                ((ExpressionNode)this.from("direct:foo").delay(10L).transform((Expression)this.constant("Bye World"))).id("myTransform");
            }
        };
    }
}

