/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedCamelContextAutoStartupTest
extends ManagementTestSupport {
    @Test
    public void testManagedCamelContext() throws Exception {
        if (ManagedCamelContextAutoStartupTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        ObjectName onRoute = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"foo\"");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"camel-1", (Object)name);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(onRoute), (String)"Should be registered");
        String state = (String)mbeanServer.getAttribute(onRoute, "State");
        Assertions.assertEquals((Object)"Stopped", (Object)state);
        mbeanServer.invoke(onRoute, "start", null, null);
        state = (String)mbeanServer.getAttribute(onRoute, "State");
        Assertions.assertEquals((Object)"Started", (Object)state);
        Object reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
        mbeanServer.invoke(on, "stop", null, null);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedCamelContextAutoStartupTest.this.context.setAutoStartup(Boolean.valueOf(false));
                this.from("direct:foo").routeId("foo").transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

