/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.JmxInstrumentationUsingPropertiesTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JmxInstrumentationDisableOnCamelContextTest
extends JmxInstrumentationUsingPropertiesTest {
    @Override
    protected boolean useJmx() {
        return false;
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext camel = super.createCamelContext();
        camel.disableJMX();
        return camel;
    }

    @Override
    @Test
    public void testMBeansRegistered() throws Exception {
        if (JmxInstrumentationDisableOnCamelContextTest.isPlatform((String)"aix")) {
            return;
        }
        this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        Set<ObjectName> s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        Assertions.assertEquals((int)0, (int)s.size(), (String)("Could not find 0 endpoints: " + s));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=contexts,*"), null);
        Assertions.assertEquals((int)0, (int)s.size(), (String)("Could not find 0 context: " + s));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        Assertions.assertEquals((int)0, (int)s.size(), (String)("Could not find 0 processor: " + s));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        Assertions.assertEquals((int)0, (int)s.size(), (String)("Could not find 0 route: " + s));
    }

    @Override
    protected void verifyCounter(MBeanServerConnection beanServer, ObjectName name) throws Exception {
        Set<ObjectName> s = beanServer.queryNames(name, null);
        Assertions.assertEquals((int)0, (int)s.size(), (String)("Found mbeans: " + s));
    }
}

