/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BacklogTracerPatternRouteTest
extends ManagementTestSupport {
    @Test
    public void testBacklogTracerPattern() throws Exception {
        if (BacklogTracerPatternRouteTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        Assertions.assertEquals((int)1000, (int)size, (String)"Should be 1000");
        mbeanServer.setAttribute(on, new Attribute("TracePattern", "coolRoute"));
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)2, (int)events.size());
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"bar"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)2, (int)events.size());
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"beer"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)0, (int)events.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerPatternRouteTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                BacklogTracerPatternRouteTest.this.context.setBacklogTracing(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("coolRoute").to("direct:beer")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
                ((RouteDefinition)this.from("direct:beer").routeId("beerRoute").to("mock:beer")).id("beer");
            }
        };
    }
}

