/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.JmxInstrumentationUsingDefaultsTest;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiInstanceProcessorTest
extends JmxInstrumentationUsingDefaultsTest {
    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process(exchange -> Thread.sleep(10L))).to("mock:end")).to("mock:end");
            }
        };
    }

    @Override
    @Test
    public void testMBeansRegistered() throws Exception {
        if (MultiInstanceProcessorTest.isPlatform((String)"aix")) {
            return;
        }
        this.assertDefaultDomain();
        this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        Set<ObjectName> s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        Assertions.assertEquals((int)2, (int)s.size(), (String)("Could not find 2 endpoints: " + s));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=context,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 context: " + s));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        Assertions.assertEquals((int)3, (int)s.size(), (String)("Could not find 3 processor: " + s));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 route: " + s));
    }

    @Override
    @Test
    public void testCounters() throws Exception {
        if (MultiInstanceProcessorTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint resultEndpoint = (MockEndpoint)this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{"<hello>world!</hello>", "<hello>world!</hello>"});
        this.sendBody("direct:start", "<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
        this.verifyCounter(this.mbsc, new ObjectName(this.domainName + ":type=routes,*"));
    }
}

