/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedSetAndRemoveHeaderAndPropertiesTest
extends ManagementTestSupport {
    @Test
    public void testSetAndRemove() throws Exception {
        if (ManagedSetAndRemoveHeaderAndPropertiesTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        Assertions.assertEquals((int)8, (int)set.size());
        boolean found = false;
        boolean found2 = false;
        boolean found3 = false;
        boolean found4 = false;
        boolean found5 = false;
        boolean found6 = false;
        for (ObjectName on : set) {
            boolean registered = mbeanServer.isRegistered(on);
            Assertions.assertEquals((Object)true, (Object)registered, (String)"Should be registered");
            String id = (String)mbeanServer.getAttribute(on, "ProcessorId");
            this.log.info("id = {}", (Object)id);
            found |= "setFoo".equals(id);
            found2 |= "setBeer".equals(id);
            found3 |= "unsetFoo".equals(id);
            found4 |= "unsetFoos".equals(id);
            found5 |= "unsetBeer".equals(id);
            found6 |= "unsetBeers".equals(id);
        }
        Assertions.assertTrue((boolean)found, (String)"Should find setHeader mbean");
        Assertions.assertTrue((boolean)found2, (String)"Should find setProperty mbean");
        Assertions.assertTrue((boolean)found3, (String)"Should find removeHeader mbean");
        Assertions.assertTrue((boolean)found4, (String)"Should find removeHeaders mbean");
        Assertions.assertTrue((boolean)found5, (String)"Should find removeProperty mbean");
        Assertions.assertTrue((boolean)found6, (String)"Should find removeProperty mbean");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").setHeader("foo", (Expression)this.constant("bar"))).id("setFoo")).setProperty("beer", (Expression)this.constant("yes"))).id("setBeer")).removeHeader("foo")).id("unsetFoo")).removeHeaders("foo")).id("unsetFoos")).removeProperty("beer")).id("unsetBeer")).removeProperties("beer")).id("unsetBeers")).to("log:foo")).id("logFoo")).to("mock:result")).id("mockResult");
            }
        };
    }
}

