/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class ManagedRouteDumpStatsAsXmlAndResetWithCustomDomainTest
extends ManagementTestSupport {
    private static final String CUSTOM_DOMAIN_NAME = "custom";

    @Test
    public void testPerformanceCounterStats() throws Exception {
        if (ManagedRouteDumpStatsAsXmlAndResetWithCustomDomainTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("custom:context=camel-1,type=routes,name=\"foo\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)mbeanServer.invoke(on, "dumpRouteStatsAsXml", new Object[]{false, true}, new String[]{"boolean", "boolean"});
        this.log.info(xml);
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Assertions.assertNotNull((Object)doc);
        int processors = doc.getDocumentElement().getElementsByTagName("processorStat").getLength();
        Assertions.assertEquals((int)3, (int)processors);
        int exchangeCompleted = Integer.parseInt(doc.getDocumentElement().getElementsByTagName("processorStat").item(0).getAttributes().getNamedItem("exchangesCompleted").getNodeValue());
        Assertions.assertEquals((int)1, (int)exchangeCompleted);
        mbeanServer.invoke(on, "reset", new Object[]{true}, new String[]{"boolean"});
        xml = (String)mbeanServer.invoke(on, "dumpRouteStatsAsXml", new Object[]{false, true}, new String[]{"boolean", "boolean"});
        this.log.info(xml);
        doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Assertions.assertNotNull((Object)doc);
        exchangeCompleted = Integer.parseInt(doc.getDocumentElement().getElementsByTagName("processorStat").item(0).getAttributes().getNamedItem("exchangesCompleted").getNodeValue());
        Assertions.assertEquals((int)0, (int)exchangeCompleted);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().getManagementStrategy().getManagementAgent().setMBeanObjectDomainName(ManagedRouteDumpStatsAsXmlAndResetWithCustomDomainTest.CUSTOM_DOMAIN_NAME);
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).id("to-log")).delay(100L).to("mock:result")).id("to-mock");
            }
        };
    }
}

