/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedLogEndpointTest
extends ManagementTestSupport {
    @Test
    public void testLogEndpoint() throws Exception {
        if (ManagedLogEndpointTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:a").expectedMessageCount(10);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("" + i));
            Thread.sleep(100L);
        }
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"log-foo\"");
        mbeanServer.isRegistered(name);
        Long total = (Long)mbeanServer.getAttribute(name, "ExchangesTotal");
        Assertions.assertEquals((int)10, (int)total.intValue());
        Integer received = (Integer)mbeanServer.getAttribute(name, "ReceivedCounter");
        Assertions.assertEquals((int)10, (int)received);
        String last = (String)mbeanServer.getAttribute(name, "LastLogMessage");
        Assertions.assertNotNull((Object)last);
        Assertions.assertTrue((boolean)last.startsWith("Received: 10 messages so far."));
        Double rate = (Double)mbeanServer.getAttribute(name, "Rate");
        Assertions.assertNotNull((Object)rate);
        Assertions.assertTrue((rate > 0.0 ? 1 : 0) != 0);
        Double average = (Double)mbeanServer.getAttribute(name, "Average");
        Assertions.assertNotNull((Object)average);
        Assertions.assertTrue((average > 0.0 ? 1 : 0) != 0);
        mbeanServer.invoke(name, "resetThroughputLogger", null, null);
        total = (Long)mbeanServer.getAttribute(name, "ExchangesTotal");
        Assertions.assertEquals((int)10, (int)total.intValue());
        last = (String)mbeanServer.getAttribute(name, "LastLogMessage");
        Assertions.assertNull((Object)last);
        received = (Integer)mbeanServer.getAttribute(name, "ReceivedCounter");
        Assertions.assertEquals((int)0, (int)received);
        rate = (Double)mbeanServer.getAttribute(name, "Rate");
        Assertions.assertEquals((Double)0.0, (Double)rate);
        average = (Double)mbeanServer.getAttribute(name, "Average");
        Assertions.assertEquals((Double)0.0, (Double)average);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo?groupSize=10")).id("log-foo")).to("mock:a");
            }
        };
    }
}

