/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DualManagedThreadPoolProfileTest
extends ManagementTestSupport {
    @Test
    public void testManagedThreadPool() throws Exception {
        if (DualManagedThreadPoolProfileTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"threads1(threads)\"");
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        Assertions.assertEquals((int)5, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        Assertions.assertEquals((int)15, (int)maxPoolSize);
        String id = (String)mbeanServer.getAttribute(on, "Id");
        Assertions.assertEquals((Object)"threads1", (Object)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        Assertions.assertEquals((Object)"threads", (Object)source);
        String route = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)route);
        String profile = (String)mbeanServer.getAttribute(on, "ThreadPoolProfileId");
        Assertions.assertEquals((Object)"custom", (Object)profile);
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"threads2(threads)\"");
        corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        Assertions.assertEquals((int)5, (int)corePoolSize);
        maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        Assertions.assertEquals((int)15, (int)maxPoolSize);
        id = (String)mbeanServer.getAttribute(on, "Id");
        Assertions.assertEquals((Object)"threads2", (Object)id);
        source = (String)mbeanServer.getAttribute(on, "SourceId");
        Assertions.assertEquals((Object)"threads", (Object)source);
        route = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route2", (Object)route);
        profile = (String)mbeanServer.getAttribute(on, "ThreadPoolProfileId");
        Assertions.assertEquals((Object)"custom", (Object)profile);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ThreadPoolProfile profile = new ThreadPoolProfile("custom");
                profile.setPoolSize(Integer.valueOf(5));
                profile.setMaxPoolSize(Integer.valueOf(15));
                profile.setKeepAliveTime(Long.valueOf(25L));
                profile.setMaxQueueSize(Integer.valueOf(250));
                profile.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
                DualManagedThreadPoolProfileTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(profile);
                this.from("direct:start").threads().executorServiceRef("custom").to("mock:result");
                this.from("direct:foo").threads().executorServiceRef("custom").to("mock:foo");
            }
        };
    }
}

