/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedRouteLoadstatisticsTest
extends ManagementTestSupport {
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testLoadStatisticsAreDisabledByDefault() throws Exception {
        if (ManagedRouteLoadstatisticsTest.isPlatform((String)"aix")) {
            return;
        }
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).delay(1200L).to("mock:result");
            }
        });
        this.context.start();
        boolean load = this.context.getManagementStrategy().getManagementAgent().getLoadStatisticsEnabled() != null && this.context.getManagementStrategy().getManagementAgent().getLoadStatisticsEnabled() != false;
        Assertions.assertFalse((boolean)load);
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String load01 = (String)mbeanServer.getAttribute(on, "Load01");
        String load05 = (String)mbeanServer.getAttribute(on, "Load05");
        String load15 = (String)mbeanServer.getAttribute(on, "Load15");
        Assertions.assertEquals((Object)"", (Object)load01);
        Assertions.assertEquals((Object)"", (Object)load05);
        Assertions.assertEquals((Object)"", (Object)load15);
    }

    @Test
    public void testEnableLoadStatistics() throws Exception {
        if (ManagedRouteLoadstatisticsTest.isPlatform((String)"aix")) {
            return;
        }
        this.context.getManagementStrategy().getManagementAgent().setLoadStatisticsEnabled(Boolean.valueOf(true));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).delay(1200L).to("mock:result");
            }
        });
        this.context.start();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> {
            String load01 = (String)mbeanServer.getAttribute(on, "Load01");
            String load05 = (String)mbeanServer.getAttribute(on, "Load05");
            String load15 = (String)mbeanServer.getAttribute(on, "Load15");
            Assertions.assertNotNull((Object)load01);
            Assertions.assertNotNull((Object)load05);
            Assertions.assertNotNull((Object)load15);
            Assertions.assertTrue((Double.parseDouble(load01.replace(',', '.')) >= 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((Double.parseDouble(load05.replace(',', '.')) >= 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((Double.parseDouble(load15.replace(',', '.')) >= 0.0 ? 1 : 0) != 0);
        });
    }
}

