/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedRouteAutoStartupTest
extends ManagementTestSupport {
    @Test
    public void testManagedCamelContext() throws Exception {
        if (ManagedRouteAutoStartupTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        ObjectName onFoo = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"foo\"");
        ObjectName onBar = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"bar\"");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"camel-1", (Object)name);
        String state = (String)mbeanServer.getAttribute(onFoo, "State");
        Assertions.assertEquals((Object)"Stopped", (Object)state);
        state = (String)mbeanServer.getAttribute(onBar, "State");
        Assertions.assertEquals((Object)"Started", (Object)state);
        mbeanServer.invoke(onFoo, "start", null, null);
        state = (String)mbeanServer.getAttribute(onFoo, "State");
        Assertions.assertEquals((Object)"Started", (Object)state);
        Object reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
        mbeanServer.invoke(on, "stop", null, null);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:bar").routeId("bar").to("mock:bar");
                this.from("direct:foo").routeId("foo").noAutoStartup().transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

