/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedNamePatternTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementNameStrategy().setNamePattern("cool-#name#");
        return context;
    }

    @Test
    public void testManagedNamePattern() throws Exception {
        if (ManagedNamePatternTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Assertions.assertTrue((boolean)this.context.getManagementName().startsWith("cool"));
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=" + this.context.getManagementName() + ",type=context,name=\"camel-1\"");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

