/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ManagedNamePatternJvmSystemPropertyTest
extends ManagementTestSupport {
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("org.apache.camel.jmx.managementNamePattern", "cool-#name#");
        super.setUp();
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("org.apache.camel.jmx.managementNamePattern");
        super.tearDown();
    }

    @Test
    public void testManagedNamePattern() throws Exception {
        if (ManagedNamePatternJvmSystemPropertyTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Assertions.assertEquals((Object)"cool-camel-1", (Object)this.context.getManagementName());
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=cool-camel-1,type=context,name=\"camel-1\"");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

