/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedInlinedProcessorTest
extends ManagementTestSupport {
    @Test
    public void testManageInlinedProcessor() throws Exception {
        if (ManagedInlinedProcessorTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"custom\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Long counter = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)1L, (long)counter);
        ManagedProcessorMBean mb = ((ManagedCamelContext)this.context.getExtension(ManagedCamelContext.class)).getManagedProcessor("custom");
        Assertions.assertNotNull((Object)mb);
        Assertions.assertEquals((long)1L, (long)mb.getExchangesCompleted());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").process(exchange -> exchange.getMessage().setBody((Object)"Bye World"))).id("custom")).to("mock:result");
            }
        };
    }
}

