/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedErrorHandlerRedeliveryTest
extends ManagementTestSupport {
    private static int counter;

    @Test
    public void testManagedErrorHandlerRedelivery() throws Exception {
        if (ManagedErrorHandlerRedeliveryTest.isPlatform((String)"aix")) {
            return;
        }
        counter = 0;
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=errorhandlers,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumRedeliveries");
        Assertions.assertEquals((int)5, (int)max);
        Long delay = (Long)mbeanServer.getAttribute(on, "MaximumRedeliveryDelay");
        Assertions.assertEquals((long)60000L, (long)delay);
        delay = (Long)mbeanServer.getAttribute(on, "RedeliveryDelay");
        Assertions.assertEquals((long)1000L, (long)delay);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"camel-1", (Object)camelId);
        Boolean dlc = (Boolean)mbeanServer.getAttribute(on, "DeadLetterChannel");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)dlc);
        Boolean dlcom = (Boolean)mbeanServer.getAttribute(on, "DeadLetterUseOriginalMessage");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)dlcom);
        Boolean tx = (Boolean)mbeanServer.getAttribute(on, "SupportTransactions");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)tx);
        String dlcUri = (String)mbeanServer.getAttribute(on, "DeadLetterChannelEndpointUri");
        Assertions.assertNull((Object)dlcUri);
        Double backoff = (Double)mbeanServer.getAttribute(on, "BackOffMultiplier");
        Assertions.assertNotNull((Object)backoff);
        Double cf = (Double)mbeanServer.getAttribute(on, "CollisionAvoidanceFactor");
        Assertions.assertNotNull((Object)cf);
        Double cp = (Double)mbeanServer.getAttribute(on, "CollisionAvoidancePercent");
        Assertions.assertNotNull((Object)cp);
        String dp = (String)mbeanServer.getAttribute(on, "DelayPattern");
        Assertions.assertNull((Object)dp);
        String ell = (String)mbeanServer.getAttribute(on, "RetriesExhaustedLogLevel");
        Assertions.assertEquals((Object)LoggingLevel.ERROR.name(), (Object)ell);
        String rll = (String)mbeanServer.getAttribute(on, "RetryAttemptedLogLevel");
        Assertions.assertEquals((Object)LoggingLevel.DEBUG.name(), (Object)rll);
        Boolean lst = (Boolean)mbeanServer.getAttribute(on, "LogStackTrace");
        Assertions.assertEquals((Object)true, (Object)lst);
        Boolean lrst = (Boolean)mbeanServer.getAttribute(on, "LogRetryStackTrace");
        Assertions.assertEquals((Object)false, (Object)lrst);
        Boolean uca = (Boolean)mbeanServer.getAttribute(on, "UseCollisionAvoidance");
        Assertions.assertEquals((Object)false, (Object)uca);
        Boolean uebf = (Boolean)mbeanServer.getAttribute(on, "UseExponentialBackOff");
        Assertions.assertEquals((Object)false, (Object)uebf);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((int)3, (int)counter);
        this.assertMockEndpointsSatisfied();
        counter = 0;
        mock.reset();
        mock.expectedMessageCount(0);
        mbeanServer.setAttribute(on, new Attribute("MaximumRedeliveries", 0));
        try {
            this.template.sendBody("direct:start", (Object)"Bye World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = (IllegalArgumentException)ManagedErrorHandlerRedeliveryTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
            Assertions.assertEquals((Object)"Forced", (Object)cause.getMessage());
        }
        Assertions.assertEquals((int)1, (int)counter);
        max = (Integer)mbeanServer.getAttribute(on, "MaximumRedeliveries");
        Assertions.assertEquals((int)0, (int)max);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(5));
                ((RouteDefinition)this.from("direct:start").process(exchange -> {
                    counter++;
                    if (counter < 3) {
                        throw new IllegalArgumentException("Forced");
                    }
                })).to("mock:result");
            }
        };
    }
}

