/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedErrorHandlerOptionsTest
extends ManagementTestSupport {
    private static int counter;

    @Test
    public void testManagedErrorHandlerOptions() throws Exception {
        if (ManagedErrorHandlerOptionsTest.isPlatform((String)"aix")) {
            return;
        }
        counter = 0;
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=errorhandlers,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        mbeanServer.setAttribute(on, new Attribute("MaximumRedeliveries", 3));
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumRedeliveries");
        Assertions.assertEquals((int)3, (int)max);
        mbeanServer.setAttribute(on, new Attribute("MaximumRedeliveryDelay", Long.valueOf("20000")));
        Long delay = (Long)mbeanServer.getAttribute(on, "MaximumRedeliveryDelay");
        Assertions.assertEquals((long)20000L, (long)delay);
        mbeanServer.setAttribute(on, new Attribute("RedeliveryDelay", Long.valueOf("250")));
        delay = (Long)mbeanServer.getAttribute(on, "RedeliveryDelay");
        Assertions.assertEquals((long)250L, (long)delay);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"camel-1", (Object)camelId);
        mbeanServer.setAttribute(on, new Attribute("BackOffMultiplier", Double.valueOf("3.5")));
        Double backoff = (Double)mbeanServer.getAttribute(on, "BackOffMultiplier");
        Assertions.assertNotNull((Object)backoff);
        mbeanServer.setAttribute(on, new Attribute("CollisionAvoidanceFactor", Double.valueOf("1.5")));
        Double cf = (Double)mbeanServer.getAttribute(on, "CollisionAvoidanceFactor");
        Assertions.assertNotNull((Object)cf);
        mbeanServer.setAttribute(on, new Attribute("CollisionAvoidancePercent", Double.valueOf("75")));
        Double cp = (Double)mbeanServer.getAttribute(on, "CollisionAvoidancePercent");
        Assertions.assertNotNull((Object)cp);
        mbeanServer.setAttribute(on, new Attribute("DelayPattern", "0:1000;5:5000"));
        String dp = (String)mbeanServer.getAttribute(on, "DelayPattern");
        Assertions.assertNotNull((Object)dp);
        mbeanServer.setAttribute(on, new Attribute("RetriesExhaustedLogLevel", "WARN"));
        String ell = (String)mbeanServer.getAttribute(on, "RetriesExhaustedLogLevel");
        Assertions.assertEquals((Object)LoggingLevel.WARN.name(), (Object)ell);
        mbeanServer.setAttribute(on, new Attribute("RetryAttemptedLogLevel", "WARN"));
        String rll = (String)mbeanServer.getAttribute(on, "RetryAttemptedLogLevel");
        Assertions.assertEquals((Object)LoggingLevel.WARN.name(), (Object)rll);
        mbeanServer.setAttribute(on, new Attribute("LogStackTrace", Boolean.TRUE));
        Boolean lst = (Boolean)mbeanServer.getAttribute(on, "LogStackTrace");
        Assertions.assertEquals((Object)true, (Object)lst);
        mbeanServer.setAttribute(on, new Attribute("UseCollisionAvoidance", Boolean.TRUE));
        Boolean uca = (Boolean)mbeanServer.getAttribute(on, "UseCollisionAvoidance");
        Assertions.assertEquals((Object)true, (Object)uca);
        mbeanServer.setAttribute(on, new Attribute("UseExponentialBackOff", Boolean.TRUE));
        Boolean uebf = (Boolean)mbeanServer.getAttribute(on, "UseExponentialBackOff");
        Assertions.assertEquals((Object)true, (Object)uebf);
        Boolean ne = (Boolean)mbeanServer.getAttribute(on, "DeadLetterHandleNewException");
        Assertions.assertEquals((Object)false, (Object)ne);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((int)3, (int)counter);
        this.assertMockEndpointsSatisfied();
        counter = 0;
        mock.reset();
        mock.expectedMessageCount(0);
        mbeanServer.setAttribute(on, new Attribute("MaximumRedeliveries", 0));
        try {
            this.template.sendBody("direct:start", (Object)"Bye World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = (IllegalArgumentException)ManagedErrorHandlerOptionsTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
            Assertions.assertEquals((Object)"Forced", (Object)cause.getMessage());
        }
        Assertions.assertEquals((int)1, (int)counter);
        max = (Integer)mbeanServer.getAttribute(on, "MaximumRedeliveries");
        Assertions.assertEquals((int)0, (int)max);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(5));
                ((RouteDefinition)this.from("direct:start").process(exchange -> {
                    counter++;
                    if (counter < 3) {
                        throw new IllegalArgumentException("Forced");
                    }
                })).to("mock:result");
            }
        };
    }
}

