/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedStickyLoadBalancerTest
extends ManagementTestSupport {
    @Test
    public void testManageStickyLoadBalancer() throws Exception {
        if (ManagedStickyLoadBalancerTest.isPlatform((String)"aix")) {
            return;
        }
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "num", (Object)"123");
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        Assertions.assertEquals((int)2, (int)size);
        String lan = (String)mbeanServer.getAttribute(on, "ExpressionLanguage");
        Assertions.assertEquals((Object)"header", (Object)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        Assertions.assertEquals((Object)"num", (Object)uri);
        String last = (String)mbeanServer.getAttribute(on, "LastChosenProcessorId");
        Assertions.assertTrue(("foo".equals(last) || "bar".equals(last) ? 1 : 0) != 0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "num", (Object)"123");
        String last2 = (String)mbeanServer.getAttribute(on, "LastChosenProcessorId");
        Assertions.assertEquals((Object)last, (Object)last2, (String)"Should be sticky");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").loadBalance().sticky((Expression)this.header("num")).id("mysend")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

