/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedRouteStopWithAbortAfterTimeoutTest
extends ManagementTestSupport {
    @Test
    public void testStopRouteWithAbortAfterTimeoutTrue() throws Exception {
        if (ManagedRouteStopWithAbortAfterTimeoutTest.isPlatform((String)"aix") || ManagedRouteStopWithAbortAfterTimeoutTest.isPlatform((String)"windows")) {
            return;
        }
        MockEndpoint mockEP = this.getMockEndpoint("mock:result");
        mockEP.setExpectedMessageCount(10);
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopWithAbortAfterTimeoutTest.getRouteObjectName(mbeanServer);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"route should be started");
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        Long timeout = new Long(1L);
        Boolean abortAfterTimeout = Boolean.TRUE;
        Object[] params = new Object[]{timeout, abortAfterTimeout};
        String[] sig = new String[]{"java.lang.Long", "java.lang.Boolean"};
        Boolean stopRouteResponse = (Boolean)mbeanServer.invoke(on, "stop", params, sig);
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertFalse((boolean)stopRouteResponse, (String)"stopRoute response should be False");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"route should still be started");
        for (int i = 5; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        mockEP.assertIsSatisfied();
    }

    @Test
    public void testStopRouteWithAbortAfterTimeoutFalse() throws Exception {
        if (ManagedRouteStopWithAbortAfterTimeoutTest.isPlatform((String)"aix") || ManagedRouteStopWithAbortAfterTimeoutTest.isPlatform((String)"windows")) {
            return;
        }
        MockEndpoint mockEP = this.getMockEndpoint("mock:result");
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopWithAbortAfterTimeoutTest.getRouteObjectName(mbeanServer);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"route should be started");
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        Long timeout = new Long(1L);
        Boolean abortAfterTimeout = Boolean.FALSE;
        Object[] params = new Object[]{timeout, abortAfterTimeout};
        String[] sig = new String[]{"java.lang.Long", "java.lang.Boolean"};
        Boolean stopRouteResponse = (Boolean)mbeanServer.invoke(on, "stop", params, sig);
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertTrue((boolean)stopRouteResponse, (String)"stopRoute response should be True");
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)state, (String)"route should be stopped");
        for (int i = 5; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        Thread.sleep(1000L);
        Assertions.assertTrue((mockEP.getExchanges().size() <= 5 ? 1 : 0) != 0, (String)"Should not have received more than 5 messages");
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedRouteStopWithAbortAfterTimeoutTest.this.context.getShutdownStrategy().setTimeout(3L);
                this.from("seda:start").delay(100L).to("mock:result");
            }
        };
    }
}

