/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagedRouteStopAndStartTest;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedRouteStopAndStartCleanupTest
extends ManagedRouteStopAndStartTest {
    @Override
    @Test
    public void testStopAndStartRoute() throws Exception {
        if (ManagedRouteStopAndStartCleanupTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopAndStartCleanupTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/data/managed", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
            Assertions.assertEquals((long)1L, (long)completed);
        });
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        Assertions.assertEquals((int)1, (int)set.size(), (String)"Should be 1 consumer");
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        Assertions.assertEquals((int)2, (int)set.size(), (String)"Should be 2 processors");
        this.log.info(">>>>>>>>>>>>>>>>>> invoking stop <<<<<<<<<<<<<<<<<<<<<");
        mbeanServer.invoke(on, "stop", null, null);
        this.log.info(">>>>>>>>>>>>>>>>>> invoking stop DONE <<<<<<<<<<<<<<<<<<<<<");
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)state, (String)"Should be stopped");
        set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        Assertions.assertEquals((int)0, (int)set.size(), (String)"Should be 0 consumer");
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        Assertions.assertEquals((int)0, (int)set.size(), (String)"Should be 0 processor");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.setResultWaitTime(2000L);
        this.template.sendBodyAndHeader("file://target/data/managed", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        mock.assertIsNotSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.log.info(">>>>>>>>>>>>>>>>> invoking start <<<<<<<<<<<<<<<<<<");
        mbeanServer.invoke(on, "start", null, null);
        this.log.info(">>>>>>>>>>>>>>>>> invoking start DONE <<<<<<<<<<<<<<<<<<");
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        Assertions.assertEquals((int)1, (int)set.size(), (String)"Should be 1 consumer");
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        Assertions.assertEquals((int)2, (int)set.size(), (String)"Should be 2 processors");
        mock.assertIsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> {
            Long num = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
            return num == 2L;
        });
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)2L, (long)completed);
    }
}

