/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedLoopTest
extends ManagementTestSupport {
    @Test
    public void testManageLoop() throws Exception {
        if (ManagedLoopTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"2");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String lan = (String)mbeanServer.getAttribute(on, "ExpressionLanguage");
        Assertions.assertEquals((Object)"header", (Object)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        Assertions.assertEquals((Object)"foo", (Object)uri);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").loop((Expression)this.header("foo")).id("mysend").to("mock:foo");
            }
        };
    }
}

