/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedEndpointBaseUriTest
extends ManagementTestSupport {
    @Test
    public void testManageEndpointBaseUri() throws Exception {
        if (ManagedEndpointBaseUriTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"log://foo\\?groupDelay=2000&groupSize=5&level=WARN\"");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Assertions.assertEquals((Object)"log://foo?groupDelay=2000&groupSize=5&level=WARN", (Object)mbeanServer.getAttribute(on, "EndpointUri"));
        Assertions.assertEquals((Object)"log://foo", (Object)mbeanServer.getAttribute(on, "EndpointBaseUri"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo?groupDelay=2000&groupSize=5&level=WARN")).to("mock:result");
            }
        };
    }
}

