/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.component.xslt.XsltOutput;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedXsltOutputBytesTest
extends ContextTestSupport {
    protected boolean useJmx() {
        return true;
    }

    protected MBeanServer getMBeanServer() {
        return this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
    }

    @Test
    public void testXsltOutput() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(byte[].class);
        this.template.sendBody("direct:start", (Object)"<hello>world!</hello>");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"xslt://org/apache/camel/component/xslt/example.xsl\\?output=bytes\"");
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        Assertions.assertEquals((Object)"xslt://org/apache/camel/component/xslt/example.xsl?output=bytes", (Object)uri);
        XsltOutput output = (XsltOutput)mbeanServer.getAttribute(on, "Output");
        Assertions.assertEquals((Object)XsltOutput.bytes, (Object)output);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)"Started", (Object)state);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/example.xsl?output=bytes")).to("mock:result");
            }
        };
    }
}

