/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.throttling.ThrottlingInflightRoutePolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedThrottlingInflightRoutePolicyTest
extends ManagementTestSupport {
    @Test
    public void testRoutes() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        Assertions.assertEquals((Object)true, (Object)registered, (String)"Should be registered");
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        Assertions.assertEquals((Object)"direct://start", (Object)uri);
        Long val = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        Assertions.assertEquals((long)0L, (long)val);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        String policy = (String)mbeanServer.getAttribute(on, "RoutePolicyList");
        Assertions.assertNotNull((Object)policy);
        Assertions.assertTrue((boolean)policy.startsWith("ThrottlingInflightRoutePolicy"), (String)("Should be a throttling, was: " + policy));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routePolicy(new RoutePolicy[]{new ThrottlingInflightRoutePolicy()}).to("log:foo")).to("mock:result");
            }
        };
    }
}

