/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.ExplicitCamelContextNameStrategy;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCamelContextTotalCounterTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementNameStrategy().setNamePattern("20-#name#");
        context.setNameStrategy((CamelContextNameStrategy)new ExplicitCamelContextNameStrategy("my-camel-context"));
        return context;
    }

    @Test
    public void testContextTotalCounter() throws Exception {
        this.template.sendBody("direct:a", (Object)"Hello World");
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"my-camel-context", (Object)name);
        String managementName = (String)mbeanServer.getAttribute(on, "ManagementName");
        Assertions.assertEquals((Object)"20-my-camel-context", (Object)managementName);
        Integer total = (Integer)mbeanServer.getAttribute(on, "TotalRoutes");
        Assertions.assertEquals((int)3, (int)total);
        Long ec = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((int)1, (int)ec.intValue());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").to("log:a")).to("direct:b");
                ((RouteDefinition)this.from("direct:b").to("log:b")).to("direct:c");
                this.from("direct:c").to("log:c");
            }
        };
    }
}

