/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.DefaultManagementAgent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.Mockito;

@ResourceLock(value="java.lang.System.properties")
@DisabledOnOs(value={OS.AIX})
public class DefaultManagementAgentMockTest {
    @Test
    public void testObjectNameModification() throws JMException {
        MBeanServer mbeanServer = (MBeanServer)Mockito.mock(MBeanServer.class);
        ObjectInstance instance = (ObjectInstance)Mockito.mock(ObjectInstance.class);
        DefaultManagementAgent agent = new DefaultManagementAgent();
        agent.setMBeanServer(mbeanServer);
        String object = "object";
        ObjectName sourceObjectName = new ObjectName("domain", "key", "value");
        ObjectName registeredObjectName = new ObjectName("domain", "key", "otherValue");
        Mockito.when((Object)mbeanServer.isRegistered(sourceObjectName)).thenReturn((Object)false);
        Mockito.when((Object)mbeanServer.registerMBean(object, sourceObjectName)).thenReturn((Object)instance);
        Mockito.when((Object)instance.getObjectName()).thenReturn((Object)registeredObjectName);
        Mockito.when((Object)mbeanServer.isRegistered(registeredObjectName)).thenReturn((Object)true);
        agent.register((Object)object, sourceObjectName);
        Assertions.assertTrue((boolean)agent.isRegistered(sourceObjectName));
        Mockito.reset((Object[])new Object[]{mbeanServer, instance});
        Mockito.when((Object)mbeanServer.isRegistered(registeredObjectName)).thenReturn((Object)true);
        mbeanServer.unregisterMBean(registeredObjectName);
        Mockito.when((Object)mbeanServer.isRegistered(sourceObjectName)).thenReturn((Object)false);
        agent.unregister(sourceObjectName);
        Assertions.assertFalse((boolean)agent.isRegistered(sourceObjectName));
    }

    @Test
    public void testShouldUseHostIPAddressWhenFlagisTrue() throws Exception {
        System.setProperty("org.apache.camel.jmx.useHostIPAddress", "true");
        try {
            DefaultCamelContext ctx = new DefaultCamelContext();
            DefaultManagementAgent agent = new DefaultManagementAgent((CamelContext)ctx);
            agent.start();
            Assertions.assertTrue((boolean)agent.getUseHostIPAddress());
        }
        finally {
            System.clearProperty("org.apache.camel.jmx.useHostIPAddress");
        }
    }

    @Test
    public void shouldUseHostNameWhenFlagisFalse() throws Exception {
        System.setProperty("org.apache.camel.jmx.useHostIPAddress", "false");
        try {
            DefaultCamelContext ctx = new DefaultCamelContext();
            DefaultManagementAgent agent = new DefaultManagementAgent((CamelContext)ctx);
            agent.start();
            Assertions.assertFalse((boolean)agent.getUseHostIPAddress());
        }
        finally {
            System.clearProperty("org.apache.camel.jmx.useHostIPAddress");
        }
    }
}

