/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Headers;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCustomBeanTest
extends ManagementTestSupport {
    @Test
    public void testManageCustomBean() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "custom");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"hey");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
        String foo = (String)mbeanServer.getAttribute(on, "Foo");
        Assertions.assertEquals((Object)"hey", (Object)foo);
        mbeanServer.setAttribute(on, new Attribute("Foo", "changed"));
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"changed");
        this.template.sendBody("direct:start", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").bean((Object)new MyCustomBean())).id("custom")).to("mock:result");
            }
        };
    }

    @ManagedResource(description="My Managed Bean")
    public static class MyCustomBean {
        private String foo = "hey";

        @ManagedAttribute
        public String getFoo() {
            return this.foo;
        }

        @ManagedAttribute
        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String doSomething(String body, @Headers Map<Object, Object> headers) throws Exception {
            headers.put("foo", this.foo);
            return "Hello " + body;
        }
    }
}

