/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedUnregisterComponentTest
extends ManagementTestSupport {
    @Test
    public void testUnregisterComponent() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=components,*"), null);
        Assertions.assertEquals((int)3, (int)set.size());
        ObjectName on = set.iterator().next();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String id = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)id);
        this.context.stop();
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(on), (String)"Should no longer be registered");
        set = mbeanServer.queryNames(new ObjectName("*:type=components,*"), null);
        Assertions.assertEquals((int)0, (int)set.size(), (String)"Should no longer be registered");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

