/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRegisterRouteTest
extends ManagementTestSupport {
    @Test
    public void testRoutes() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        Assertions.assertEquals((Object)true, (Object)registered, (String)"Should be registered");
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        Assertions.assertEquals((Object)"direct://start", (Object)uri);
        String id = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"myRoute", (Object)id);
        String group = (String)mbeanServer.getAttribute(on, "RouteGroup");
        Assertions.assertEquals((Object)"myGroup", (Object)group);
        String desc = (String)mbeanServer.getAttribute(on, "Description");
        Assertions.assertEquals((Object)"my cool route", (Object)desc);
        Long val = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        Assertions.assertEquals((long)0L, (long)val);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        this.context.getRouteController().stopRoute(((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId());
        registered = mbeanServer.isRegistered(on);
        Assertions.assertEquals((Object)true, (Object)registered, (String)"Should be registered");
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)state, (String)"Should be stopped");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").routeGroup("myGroup").description("my cool route")).to("log:foo")).to("mock:result");
            }
        };
    }
}

