/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Collections;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedStartupFailedTest
extends ManagementTestSupport {
    public boolean isUseRouteBuilder() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllGood() throws Exception {
        Set<ObjectName> onames;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        this.context.start();
        MBeanServer server = this.getMBeanServer();
        try {
            onames = server.queryNames(new ObjectName("org.apache.camel:*"), null);
            Assertions.assertTrue((onames.size() > 0 ? 1 : 0) != 0);
            ProducerTemplate producer = this.context.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assertions.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            this.context.stop();
        }
        onames = server.queryNames(new ObjectName("org.apache.camel:*"), null);
        Assertions.assertEquals(Collections.emptySet(), onames);
    }

    @Test
    public void testStartupFailure() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("invalid:start");
            }
        });
        try {
            this.context.start();
            Assertions.fail((String)"Startup failure expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MBeanServer server = this.getMBeanServer();
        Assertions.assertNull((Object)server);
    }
}

