/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteWithOnExceptionTest
extends ManagementTestSupport {
    @Test
    public void testShouldBeInstrumentedOk() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testShouldBeInstrumentedKabom() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kabom");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException camelExecutionException) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testShouldBeInstrumentedOkAndKabom() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        try {
            this.template.sendBody("direct:start", (Object)"Kabom");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException camelExecutionException) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((OnExceptionDefinition)this.from("direct:start").onException(Exception.class).to("mock:error")).end().delay(100L).choice().when(this.body().isEqualTo((Object)"Kabom")).throwException((Exception)new IllegalArgumentException("Kabom"))).otherwise().to("mock:result")).end();
            }
        };
    }
}

